'==========================================================================
'
' Author......: Chiatto Raffaele
'
' WebSite.....: http://www.chiattoraffaele.it
'
' E-Mail......: raffaele.chiatto@gmail.com
'
' Desription..: Prende in input un file csv (parametro) configurato nel seguento modo:
'               SamAccountName;Cognome;Nome
'               NON supporta la prima riga del titolo.
'               Aggiunge un indirizzo SMTP nel formato <inziale nome>.<cognome>@dominio.it
'               rendendolo indirizzo SMTP primario.
'               Lo script aggiorna subito anche il campo "mail".
'
' Note........: NON gestisce i casi di omonimia, perch assume che siano stati gestiti
'               a livello del file di input. (comunicazione dell'utilizzatore dello script)
'
'
'
'
'==========================================================================


' PARAMETRI DA CONFIGURARE
'-------------------------
DomainController="Nome NetBios Domain Controller"
ldapSearchRoot="LDAP://" & DomainController & "/dc=test,dc=prv"
OutputFile="c:\File.csv"


'--- SCRIPT STARTS HERE ---


InputFile=wscript.arguments(0)
Set oFSO=CreateObject("Scripting.FileSystemObject")
Set oOutPutFile=oFSO.OpenTextFile(OutputFile,2,true)
Set oInPutFile=oFSO.OpenTextFile(InputFile,1,false)

Dim arrIN()
Dim arrILine
arrINLine=-1

Do until oInPutFile.AtEndOfStream
   line=oInPutFile.ReadLine
   LineFields=Split(Line,";")

   arrInLine=arrInLine+1
   redim preserve arrIN(3,arrInLine)
   arrIn(0,arrInLine)=LineFields(0)
   arrIn(1,arrInLine)=LineFields(1)
   arrIn(2,arrInLine)=LineFields(2)
loop

   
   Const ADS_SCOPE_BASE = 0
   Const ADS_SCOPE_ONE = 1
   Const ADS_SCOPE_SUBTREE = 2
   subtree=ADS_SCOPE_SUBTREE
   Set objConnection = CreateObject("ADODB.Connection")
   Set objCommandOU = CreateObject("ADODB.Command")
   Set objCommandList = CreateObject("ADODB.Command")
   objConnection.Provider = "ADsDSOObject"
   objConnection.Open "Active Directory Provider"
   
   Set objCommandOU.ActiveConnection = objConnection
   objCommandOU.Properties("Page Size") = 1000
   objCommandOU.Properties("Timeout") = 30 
   objCommandOU.Properties("Cache Results") = False
   objCommandOU.Properties("Searchscope") = subtree


   Dim UsrDistName,UsrFirstName,UsrSurname,UsrSamAccName
   on error resume next
   for q=0 to uBound(arrIn,2)
      objCommandOU.CommandText = "Select SamAccountName,DistinguishedName from '" & ldapSearchRoot &"' " & "where SamAccountName='" & arrIn(0,q) & "'"
      Set objRecordSetOU = objCommandOU.Execute
      objRecordSetOU.MoveFirst
      if err.number=0 then
         UsrDistName=objRecordSetOU.Fields("DistinguishedName").value
         UsrFirstName=arrIn(2,q)
         UsrSurname=arrIn(1,q)
         UsrSamAccName=objRecordSetOU.Fields("SamAccountName").value

         SMTPtoAdd =CreaSMTP(UsrFirstName,UsrSurname)
         AddSMTPAddress UsrDistName,SMTPtoAdd
         SetAsPrimary UsrDistName,SMTPtoAdd

         UsrDistName=null
         UsrFirstName=null
         UsrSurname=null
         UsrSamAccName=null

         arrIn(3,q)=SMTPtoAdd
      else
         arrIn(3,q)="Non trovato in AD"
      end if
      err.clear
   next


   for q=0 to uBound(arrIn,2)
      OutLine=arrIn(0,q)
      for w=1 to uBound(arrIn,1)
         OutLine=OutLine & ";" & arrIn(w,q)
      next
      oOutPutFile.WriteLine OutLine
   next

   MSGBOX "Aggiornamento indirizzi SMTP primary per Dominio.it terminato.",+vbinformation,"SMTP Update"

Function CreaSMTP(Nome,Cognome)
   SMTPName=Lcase(Left(Nome,1) & "." & Cognome)
   SMTPName=Replace(SMTPName,"'","")
   SMTPName=Replace(SMTPName," ","")
   SMTPName=Replace(SMTPName,"","a")
   SMTPName=Replace(SMTPName,"","e")
   SMTPName=Replace(SMTPName,"","e")
   SMTPName=Replace(SMTPName,"","o")
   SMTPName=Replace(SMTPName,"","u")
   CreaSMTP=SMTPName & "@dominio.it"
end function



Sub AddSMTPAddress(distname,sAddress)
   Set oUser = GetObject ("LDAP://" & DomainController & "/" & distname)
   Set objRecip = oUser
   AlreadyPresentAddress=0
   vProxyAddresses = objRecip.ProxyAddresses
   nProxyAddresses = UBound(vProxyAddresses)

   i = 0
   Do While i <= nProxyAddresses
      If lcase(vProxyAddresses(i)) = "smtp:" & lcase(sAddress)  Then
         AlreadyPresentAddress=1
         Exit Do
      End If
      i = i + 1
   Loop

   If AlreadyPresentAddress=0 Then
'      wscript.echo "aggiunto indirizzo: " & sAddress
      ReDim Preserve vProxyAddresses(nProxyAddresses + 1)
      vProxyAddresses(nProxyAddresses + 1) = "smtp:" & sAddress
      objRecip.ProxyAddresses = vProxyAddresses
      oUser.SetInfo
   else
'      wscript.echo "indirizzo gi esistente: " & sAddress
   End If
end sub



Sub SetAsPrimary(distname,sAddress)
   Set oUser = GetObject ("LDAP://" & DomainController & "/" & distname)
   Set objRecip = oUser
   AlreadyPresentAddress=0
   vProxyAddresses = objRecip.ProxyAddresses
   nProxyAddresses = UBound(vProxyAddresses)

   i = 0
   Do While i <= nProxyAddresses
      If Left(vProxyAddresses(i),5) = "SMTP:"Then
         vProxyAddresses(i)="smtp:" & Mid(vProxyAddresses(i),6)
      End If
      If Lcase(Mid(vProxyAddresses(i),6))=saddress then
         vProxyAddresses(i)="SMTP:" & Mid(vProxyAddresses(i),6)
         oUser.mail=Mid(vProxyAddresses(i),6)
      end if
      i = i + 1
   Loop

   objRecip.ProxyAddresses = vProxyAddresses
   oUser.SetInfo
end sub
